/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.handler;

import frc.emul.config.data.CfgItemController;
import frc.emul.config.handler.CLHConfiguration;
import frc.emul.config.handler.CLHControllerButton;
import frc.emul.config.handler.CLHControllerDirection;
import frc.emul.config.handler.ConfigLoaderHandler;
import frc.util.xml.XMLLoaderHandler;
import org.xml.sax.Attributes;

public class CLHControllers
extends ConfigLoaderHandler {
    final boolean rootLevel;
    CfgItemController ctrl;

    CLHControllers(CLHConfiguration cLHConfiguration) {
        super(cLHConfiguration);
        this.rootLevel = true;
    }

    private CLHControllers(CLHControllers cLHControllers) {
        super(cLHControllers);
        this.rootLevel = false;
    }

    public void pushed(Attributes attributes) {
        if (this.rootLevel) {
            if (!CLHControllers.loadBool(attributes, "enabled", true)) {
                this.getConfig().setControllersDisabled(true);
            }
        } else {
            String string = attributes.getValue("id");
            if (string == null) {
                throw new RuntimeException("Empty controller ID");
            }
            this.ctrl = new CfgItemController(string);
        }
    }

    public void poped() {
        if (!this.rootLevel) {
            this.getConfig().addController(this.ctrl);
        }
    }

    public XMLLoaderHandler getChildHandler(String string, Attributes attributes) {
        if (this.rootLevel) {
            if (string.equals("controller")) {
                return new CLHControllers(this);
            }
        } else {
            if (string.equals("direction")) {
                return new CLHControllerDirection(this);
            }
            if (string.equals("button")) {
                return new CLHControllerButton(this);
            }
        }
        return super.getChildHandler(string, attributes);
    }
}

